<?php
function getTitle($filePath) {
    $content = file_get_contents($filePath);
    if (preg_match("/<title>(.*)<\/title>/i", $content, $matches)) {
        return $matches[1];
    } else {
        return "No title found";
    }
}

function getPoster($filePath) {
    $content = file_get_contents($filePath);
    if (preg_match('/<video[^>]+poster=["\']([^"\']+)["\'][^>]*>/i', $content, $matches)) {
        return $matches[1];
    } elseif (preg_match('/<meta[^>]+property=["\']og:image["\'][^>]*content=["\']([^"\']+)["\']/i', $content, $matches)) {
        return $matches[1];
    } else {
        return "";
    }
}

function getFiles($dirs) {
    $files = [];
    foreach ($dirs as $dir) {
        $allowedPath = realpath($dir); // 获取允许访问的路径的绝对路径
        $iterator = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($dir));
        foreach ($iterator as $file) {
            $realPath = realpath($file->getPathname());
            if (strpos($realPath, $allowedPath) === 0 && $file->isFile() && in_array($file->getExtension(), ['html'])) {
                $files[] = [
                    'path' => $file->getPathname(),
                    'creation_time' => filectime($file->getPathname())
                ];
            }
        }
    }
    return $files;
}

function searchKeywordInTitle($title, $keyword) {
    return stripos($title, $keyword) !== false;
}

$keyword = '.';
$results = [];
if ($keyword) {
    // 仅搜索子目录ys和子目录dy
    $directories = [__DIR__ . '/ys', __DIR__ . '/v'];
    $files = getFiles($directories);

    // 按创建时间排序文件列表
    usort($files, function($a, $b) {
        return $b['creation_time'] - $a['creation_time'];
    });

    foreach ($files as $file) {
        $title = getTitle($file['path']);
        $poster = getPoster($file['path']);
        if (searchKeywordInTitle($title, $keyword)) {
            $results[] = [
                'url' => str_replace($_SERVER['DOCUMENT_ROOT'], '', $file['path']),
                'poster' => $poster,
                'title' => $title
            ];
        }
    }
    // 分页变量
    $itemsPerPage = 16;
    $totalItems = count($results);
    $totalPages = ceil($totalItems / $itemsPerPage);

    for ($currentPage = 1; $currentPage <= $totalPages; $currentPage++) {
        $startIndex = ($currentPage - 1) * $itemsPerPage;
        $paginatedResults = array_slice($results, $startIndex, $itemsPerPage);
        // 生成静态HTML文件
        $htmlContent = '<!DOCTYPE html>
<html lang="zh-CN">
<head>
  <meta charset="UTF-8">
  <meta name="referrer" content="never">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Hi音 | 一个很棒的音乐网站</title>
  <style>
body, html {
    margin: 0;
    padding: 0;
    font-family: Arial, sans-serif;
    background-color: #223;
    color: #fff;
    font-size: 18px;
}
.container {
    max-width: 800px;
    margin: 0 auto;
    padding: 20px;
}
.nav {
    background-color: #333;
    padding: 10px;
    display: flex;
    justify-content: flex-start;
    gap: 1px; /* 缩小的水平间距 */
}
.nav a {
    color: #ddd;
    text-decoration: none;
    margin: 0;
    padding: 8px 10px;
    border-radius: 4px;
    transition: background-color 0.3s ease;
    font-size: 14px;
    white-space: nowrap; /* 确保链接不换行 */
}
.nav a:hover {
    background-color: #555;
}
.search-container {
    background-color: #f0b4a3;
    padding: 20px;
    box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
    margin-bottom: 20px;
    border-radius: 8px;
}
#results {
    list-style: none;
    padding: 0;
    display: grid;
    grid-template-columns: repeat(2, 1fr); /* 两列布局 */
    gap: 10px;
}
#results li {
    background-color: #333;
    margin-bottom: 6px;
    padding: 4px;
    border-radius: 4px;
    transition: background-color 0.3s ease;
}
#results li a {
    color: #ddd;
    text-decoration: none;
    display: block;
    width: 100%;
    height: 100%;
    overflow: hidden;
    margin: 0; /* 清除所有外边距 */
    padding: 0; /* 无内边距 */
}
#results li a img {
    width: 100%;
    height: auto;
}
#results li .title {
    font-size: 12px; /* 修改标签文字为12px */
    color: #fff;
    text-align: left; /* 靠左显示 */
    width: 97.5%; /* 跟图片等宽 */
    margin: 0; /* 清除所有外边距 */
    padding: 0; /* 无内边距 */
    box-sizing: border-box; /* 包含内边距 */
    display: block; /* 确保块级元素 */
    position: relative; /* 使用相对定位 */
    left: 3px; /* 向左移动10px */
    white-space: normal; /* 确保文字换行 */
    word-break: break-word; /* 防止长单词溢出 */
}
#results li:hover {
    background-color: #555;
}
.pagination {
    text-align: center;
    margin-top: 20px;
}
.pagination a {
    color: #ddd;
    text-decoration: none;
    margin: 0 5px; /* 调整间距 */
    padding: 7px 10px; /* 缩小按钮尺寸 */
    border-radius: 4px;
    background-color: #444;
    transition: background-color 0.3s ease;
    font-size: 15px; /* 可以调整字体大小 */
}
.pagination a:hover {
    background-color: #555;
}
footer {
    background-color: #333;
    padding: 10px;
    text-align: center;
    color: #ddd;
    position: fixed;
    width: 100%;
    bottom: 0;
}
.title {
    color: #333;
    font-size: 1.05em;
    font-weight: bold; /* 加粗 */
    position: relative;
    left: 15px; /* 设置靠左 */
}

  </style>
</head>
<body>
    <div class="container">
        <div class="nav">
            <a href="/">首页</a>
            <a href="/v1.html">Music视频</a>
            <a href="/page1.html">手机影院</a>
            <a href="https://pan.quark.cn/s/3e53c958f8dc">音乐下载</a>
        </div>
        <div class="search-container">
            <div class="title">
            Hi音 | 建议在微信中收藏/欣赏...
            </div>
            <ul id="results">';   
        foreach ($paginatedResults as $result) {
            if ($result['poster'] !== "") {
                $htmlContent .= '<li><a href="' . $result['url'] . '"><img src="' . htmlspecialchars($result['poster']) . '" alt="' . htmlspecialchars($result['title']) . '"><div class="title">' . htmlspecialchars($result['title']) . '</div></a></li>';
            }
        }
        $htmlContent .= '
            </ul>
            <div class="pagination">';
        
        if ($currentPage > 1) {
            $htmlContent .= '<a href="v' . ($currentPage - 1) . '.html">上一页</a>';
        }
        if ($currentPage < $totalPages) {
            $htmlContent .= '<a href="v' . ($currentPage + 1) . '.html">下一页</a>';
        }

        $htmlContent .= '</div>
            </div>
        </div>
        <footer>
            &copy; ' . date('Y') . ' Hi音.by meiliwuya
        </footer>
    </body>
    <script type="text/javascript" src="https://js.users.51.la/20590531.js"></script>
    </html>';

        file_put_contents('v' . $currentPage . '.html', $htmlContent);
    }
}
?>
