<?php
function getTitle($filePath) {
    $content = file_get_contents($filePath);
    if (preg_match("/<title>(.*)<\/title>/i", $content, $matches)) {
        return $matches[1];
    } else {
        return "No title found";
    }
}

function getFiles($dirs) {
    $files = [];
    foreach ($dirs as $dir) {
        $allowedPath = realpath($dir); // 获取允许访问的路径的绝对路径
        $iterator = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($dir));
        foreach ($iterator as $file) {
            $realPath = realpath($file->getPathname());
            if (strpos($realPath, $allowedPath) === 0 && $file->isFile() && in_array($file->getExtension(), ['html'])) {
                $files[] = [
                    'path' => $file->getPathname(),
                    'creation_time' => filectime($file->getPathname())
                ];
            }
        }
    }
    return $files;
}

function searchKeywordInTitle($title, $keyword) {
    return stripos($title, $keyword) !== false;
}

$keyword = '♫';
$results = [];
if ($keyword) {
    // 仅搜索子目录a和子目录V
    $directories = [__DIR__ . '/a', __DIR__ . '/ys', __DIR__ . '/dy'];
    $files = getFiles($directories);

    // 按创建时间排序文件列表
    usort($files, function($a, $b) {
        return $b['creation_time'] - $a['creation_time'];
    });

    foreach ($files as $file) {
        $title = getTitle($file['path']);
        if (searchKeywordInTitle($title, $keyword)) {
            $results[] = [
                'url' => str_replace($_SERVER['DOCUMENT_ROOT'], '', $file['path']),
                'title' => $title
            ];
        }
    }

    // 生成静态HTML文件
    $htmlContent = '<!DOCTYPE html>
<html lang="zh-CN">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Hi音 | 一定有你喜欢的音乐 </title>
  <style>
    body, html {
        margin: 0;
        padding: 0;
        font-family: Arial, sans-serif;
        background-color: #223;
        color: #fff;
        font-size: 16px;
    }
    .container {
        max-width: 800px;
        margin: 0 auto;
        padding: 20px;
    }
    .nav {
        background-color: #333;
        padding: 10px;
        display: flex;
        justify-content: flex-start;
        gap: 1px; /* 缩小的水平间距 */
    }
    .nav a {
        color: #ddd;
        text-decoration: none;
        margin: 0;
        padding: 8px 10px;
        border-radius: 4px;
        transition: background-color 0.3s ease;
        font-size: 14px;
        white-space: nowrap; /* 确保链接不换行 */
    }
    .nav a:hover {
        background-color: #555;
    }
    .search-container {
        background-color: #f0b4a3;
        padding: 20px;
        box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        margin-bottom: 20px;
        border-radius: 8px;
    }
    #results {
        list-style: none;
        padding: 0;
    }
    #results li {
        background-color: #333;
        margin-bottom: 6px;
        padding: 8px;
        border-radius: 4px;
        transition: background-color 0.3s ease;
    }
    #results li a {
        color: #ddd;
        text-decoration: none;
    }
    #results li:hover {
        background-color: #555;
    }
    footer {
        background-color: #333;
        padding: 10px;
        text-align: center;
        color: #ddd;
        position: fixed;
        width: 100%;
        bottom: 0;
    }
    .title {
	    color: #333;
        font-size: 1.05em;
		font-weight: bold; /* 加粗 */
        position: relative;
        left: 15px; /* 设置靠左134px */
    }
  </style>
</head>
<body>
    <div class="container">
        <div class="nav">
            <a href="/">首页</a>
            <a href="/v1.html">Music视频</a>
            <a href="/page1.html">手机影院</a>
            <a href="https://pan.quark.cn/s/3e53c958f8dc">音乐下载</a>
        </div>
        <div class="search-container">
		    <div class="title">
            Hi音 | 一定有你喜欢的音乐 ...
			</div>
            <ul id="results"><li><a href="/a/3.html">置顶 ↑ 10年珍藏 | 无损音乐 30首 ♫</a></li> <li><a href="/a/2.html">置顶 ↑ Hamidshax专辑 | 300首 ♫</a></li> <li><a href="/cc/erge.html">置顶 ↑ 送给我宝宝的 | 宝宝儿歌</a></li>';            

    foreach ($results as $result) {
        $htmlContent .= '<li><a href="' . $result['url'] . '">' . htmlspecialchars($result['title']) . '</a></li>';
    }

    $htmlContent .= '
            <li>... ...</li>
            </ul>
        </div>
    </div>
    <footer>
        &copy; ' . date('Y') . ' Hi音.by meiliwuya
    </footer>
</body>
<script type="text/javascript" src="https://js.users.51.la/20590531.js"></script>
</html>';

    file_put_contents('index.html', $htmlContent);
}
?>
<style>
a {
	text-decoration:none;
}
</style>
<big><b><center><br><br><br><br><br><br><br><br><hr><br>
<a href="/ss-dy.php" style="font-size: 24px;">网站已刷新 - 1</a>&nbsp;&nbsp;&nbsp;
<meta http-equiv="refresh" content="0.1;url=/ss-v.php">
  </body>
  </html>

