<?php
header('Content-Type: text/html; charset=UTF-8');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $titleInput = $_POST['titleInput'];
    $userInput = $_POST['userInput'];
    $coverInput = $_POST['coverInput']; // 获取封面图输入内容
    $originalFile = '001.html';
    $directory = 'a/';

    // 读取原始文件内容
    $originalContent = file_get_contents($originalFile);

    // 替换内容并保留特殊字符，移除所有换行符和回车符
    $safeTitleInput = htmlspecialchars($titleInput, ENT_QUOTES, 'UTF-8');
    $safeUserInput = preg_replace('/[\r\n]+/', ' ', $userInput); // 移除所有换行符和回车符
    $safeCoverInput = htmlspecialchars($coverInput, ENT_QUOTES, 'UTF-8'); // 安全处理封面图输入内容



    $newContent = str_replace('<!--替换内容2-->', $safeTitleInput, $originalContent);
    $newContent = str_replace('<!--替换内容1-->', $safeUserInput, $newContent);
    $newContent = str_replace('<!--替换内容3-->', $safeCoverInput, $newContent); // 替换封面图内容

    // 生成随机文件名
    $fileName = '';
    for ($i = 0; $i < 12; $i++) {
        $fileName .= rand(1, 9);
    }
    $fileName .= '.html';

    // 确保目录存在
    if (!is_dir($directory)) {
        mkdir($directory, 0777, true);
    }

    // 保存新文件
    file_put_contents($directory . $fileName, $newContent);

    // 重定向到表单页面并传递文件名参数
    header('Location: 001.php?file=' . urlencode($fileName));
    exit;
}
?>
