        function getChromeVersion() {
            var ua = navigator.userAgent;
            var chromeVersion = ua.match(/Chrome\/(\d+)/);
            if (chromeVersion) {
                return parseInt(chromeVersion[1], 10);
            } else {
                return null;
            }
        }
        function applyStylesheetBasedOnVersion() {
            var version = getChromeVersion();
            if (version !== null && version === 130) {
                var link = document.createElement('link');
                link.rel = 'stylesheet';
                link.href = '130.css'; // 加载特定版本130的CSS
                document.head.appendChild(link);
                document.getElementById('browserInfo').textContent = '您正在使用Chrome浏览器，版本号为: ' + version + '。已加载130.css样式表。';
            } 
        }
        document.addEventListener('DOMContentLoaded', applyStylesheetBasedOnVersion);